/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import com.ibm.websphere.management.JMXManageable;
import com.ibm.websphere.runtime.CustomService;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWAutoStartupShutdownProperties;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWComponentManager;
import filenet.vw.integrator.base.VWCMConvertTwo;
import filenet.vw.integrator.base.VWComponentManager;
import java.io.File;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWComponentManagerCustomServiceMBean
implements CustomService,
JMXManageable {
    private VWComponentManager cmgr = null;
    private VWTaskXMLHandler m_xmlHandler = null;
    private static final int KEY_MASK = 0;
    private static String CMRegistryName = "FileNet.VW.VWComponentManager";
    private String adoptorName = null;
    private String routerURL = null;
    private String userName = "-1";
    private String password = null;
    private int cmPort = 0;
    private int eventPort = 0;
    private boolean isCustomService = true;
    private String customSvcConfigURL = null;
    private String taskManagerXMLPath = null;
    private String m_aeinstallhomepath = null;
    private final String ROUTER_URL = "peRouterURL";
    private final String USER = "peUserName";
    private final String PW = "pePassword";
    private final String CM_PORT = "peCMPort";
    private final String EVENT_PORT = "peEventPort";
    private final String P8BPMWSBROKER_PROPERTIES_PATH = "p8BPMWSBroker";
    private Properties properties = null;
    private String jndiInitCtx = null;
    private String reqlibs = null;
    protected static boolean QUEUEMODE_ENABLED = true;
    protected static final String UNDEFINED = "UNDEFINED";
    private String m_queues = "*";
    private Boolean m_StopRequested = Boolean.FALSE;
    private String m_codebaseURLForm = null;
    private static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    private static String m_className = "VWComponentManagerCustomServiceMBean";
    private MainThread m_mainThread = null;
    private static String P8BPMWSBROKER_PROPERTIES_FILENAME = null;
    private String m_p8bpmwsbroker_path = null;
    private Vector m_componentManagers = new Vector(1);
    private static boolean bWindowsOS = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");

    public void initialize(Properties props) throws Exception {
        String m_method = "initialize";
        System.out.println("VWComponentManagerCustomServiceMBean.initialize(" + props + ")");
        this.routerURL = this.routerURL == null ? props.getProperty("peRouterURL") : this.routerURL;
        this.cmPort = Integer.parseInt(props.getProperty("peCMPort"));
        if (this.cmPort == 0) {
            throw new VWException("vw.router.VWCMCustomServiceMissingPropertyCMPort", "Missing custom service property peCMPort.");
        }
        this.m_p8bpmwsbroker_path = this.m_p8bpmwsbroker_path == null ? props.getProperty("p8BPMWSBroker") : this.m_p8bpmwsbroker_path;
        File f = new File(this.m_p8bpmwsbroker_path, "P8BPMWSBroker.properties");
        P8BPMWSBROKER_PROPERTIES_FILENAME = f.getCanonicalPath();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "CMCustomService=" + P8BPMWSBROKER_PROPERTIES_FILENAME);
        }
        this.properties = props;
        System.out.println("Starting component manager...");
        this.m_mainThread = new MainThread(this);
        this.m_mainThread.start();
    }

    protected String getQueues() {
        return this.m_queues;
    }

    protected void setQueues(String q) {
        this.m_queues = q;
    }

    private String getNameFromQueueMode() {
        if (!QUEUEMODE_ENABLED) {
            return this.getRouterURL();
        }
        if (this.m_queues.equals("*")) {
            return this.getRouterURL() + ".ALL";
        }
        return this.getRouterURL() + "." + this.m_queues.replace(',', '.');
    }

    public void shutdown() {
        try {
            this.stopCM();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("VWComponentManagerCustomServiceMBean.shutdown()");
    }

    public String getType() {
        System.out.println("VWComponentManagerCustomServiceMBean.getType()");
        return "FnpeCM";
    }

    public Properties getMBeanProperties() {
        System.out.println("VWComponentManagerCustomServiceMBean.getMBeanProperties()");
        Properties props = new Properties();
        props.put("Identification", "fnpecompmgr1");
        return props;
    }

    public String getIdentification() {
        System.out.println("VWComponentManagerCustomServiceMBean.getIdentification()");
        return "fnpecompmgr1";
    }

    public String getAdaptorName() {
        System.out.println("VWComponentManagerCustomServiceMBean.getAdaptorName()");
        String[] adoptorNames = null;
        try {
            adoptorNames = this.cmgr.getAdaptorNames();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        if (null != adoptorNames) {
            return adoptorNames[0];
        }
        return "fnpeAdaptor";
    }

    public String getRouterURL() {
        System.out.println("VWComponentManagerCustomServiceMBean.getRouterURL()");
        return this.routerURL;
    }

    public void setRouterURL(String routerURL) {
        System.out.println("VWComponentManagerCustomServiceMBean.setRouterURL(" + routerURL + ")");
        this.routerURL = routerURL;
    }

    public int getCMPort() {
        System.out.println("VWComponentManagerCustomServiceMBean.getCMPort()");
        return this.cmPort;
    }

    public void setCMPort(int cmPort) {
        System.out.println("VWComponentManagerCustomServiceMBean.setCMPort(" + cmPort + ")");
        this.cmPort = cmPort;
    }

    public int getEventPort() {
        System.out.println("VWComponentManagerCustomServiceMBean.getEventPort()");
        return this.eventPort;
    }

    public void setEventPort(int PPMPort) {
        System.out.println("VWComponentManagerCustomServiceMBean.setEventPort(" + PPMPort + ")");
        this.eventPort = PPMPort;
    }

    public String getRequiredLibraries() {
        return this.reqlibs;
    }

    public void setRequiredLibraries(String reqlibraries) {
        this.reqlibs = reqlibraries;
    }

    public String getJNDIContext() {
        return this.jndiInitCtx;
    }

    public void setJNDIContext(String context) {
        this.jndiInitCtx = context == null ? null : (context.trim().equals("") ? null : context);
    }

    public void stopCM() throws Exception {
        System.out.println("VWComponentManagerCustomServiceMBean.stopCM()");
        String m_method = "stopCM";
        this.m_StopRequested = Boolean.TRUE;
        logger.info(m_className, m_method, "VWComponentManagerCustomServiceMBean.stopCM()");
        boolean errorOccured = false;
        Node cmNode = null;
        VWComponentManager vwCM = null;
        Enumeration e = this.m_componentManagers.elements();
        while (e.hasMoreElements()) {
            try {
                cmNode = (Node)e.nextElement();
                this.cmFromXML(cmNode);
                logger.info(m_className, m_method, "Stopping component manager...");
                vwCM = (VWComponentManager)VWComponentManagerCustomServiceMBean.lookupCM(this.cmPort);
                if (this.isStarted()) {
                    vwCM.stop(true);
                }
                logger.info(m_className, m_method, "Component manager stopped successfully");
            }
            catch (Exception ex) {
                errorOccured = true;
                logger.info(m_className, m_method, new VWString("filenet.vw.integrator.base.VWComponentManagerCustomServiceMBean.UnableToStopCM", "Unable to stop Component Manager {0}: {1}").toString(this.getNameFromQueueMode(), ex.getLocalizedMessage()));
                logger.warning(m_className, m_method, ex.getLocalizedMessage());
            }
        }
        if (errorOccured) {
            throw new VWException("filenet.vw.integrator.base.VWComponentManagerCustomServiceMBean.AtLeastOneCMFailedToStop", "At least one Component Manager failed to stop");
        }
        this.cmgr = null;
    }

    private void startCM() throws Exception {
        System.out.println("VWComponentManagerCustomServiceMBean.startCM()");
        String m_method = "startCM";
        if (!this.isStarted()) {
            try {
                block10: {
                    try {
                        IVWComponentManager smi = VWComponentManagerCustomServiceMBean.lookupCM(this.cmPort);
                        if (smi != null) {
                            String[] adaptorNames = smi.getAdaptorNames();
                            System.out.println("Component Manager is already running.");
                            throw new VWException("vw.integrator.base.VWCMAlreadyRunning", "The component manager is already running on this server.");
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof VWException)) break block10;
                        throw e;
                    }
                }
                if (this.userName.equals("-1")) {
                    VWCMConvertTwo converter = new VWCMConvertTwo(0);
                    VWAuthItem item = converter.getDString(this.password);
                    if (item != null) {
                        this.userName = item.getName();
                        this.password = item.getPassword();
                        if (this.password != null && this.password.compareTo("\"\"") == 0) {
                            this.password = "";
                        }
                    } else {
                        System.out.println("Invalid name or password.");
                        throw new VWException("vw.integrator.base.VWCMInvalidUserNamePassword", "User name or password is invalid.");
                    }
                }
                String name = CMRegistryName + "." + this.getNameFromQueueMode();
                String queues = QUEUEMODE_ENABLED ? this.m_queues : "";
                logger.info(m_className, m_method, "Name=" + name + "queues=" + queues);
                this.cmgr = new VWComponentManager(name, this.userName, this.password, this.routerURL, this.cmPort, this.eventPort, this.isCustomService, queues);
                System.out.println("ComponentManager bound in registry.");
            }
            catch (Exception ex) {
                this.cmgr = null;
                throw ex;
            }
        }
    }

    private boolean isStarted() {
        return this.cmgr != null;
    }

    protected static IVWComponentManager lookupCM(int rmiPort) throws Exception {
        String url = "rmi://localhost:" + rmiPort + "/" + CMRegistryName;
        return (IVWComponentManager)Naming.lookup(url);
    }

    private void addComponentManagerNode(Node n) {
        this.m_componentManagers.add(n);
    }

    private void initCMCollectionFromXML() throws Exception {
        String m_method = "initCMCollectionFromXML";
        StringBuffer aeinstallhome = VWAutoStartupShutdownProperties.GetAEInstallHome(P8BPMWSBROKER_PROPERTIES_FILENAME);
        if (null == aeinstallhome || aeinstallhome.length() == 0) {
            logger.info(m_className, m_method, "AE install home is undefined.");
            throw new VWException("vw.integrator.base.VWCMCSMBAEInstallHomeNotDefined", "AE Install home is undefined.");
        }
        this.m_aeinstallhomepath = new String(aeinstallhome);
        StringBuffer buff = VWAutoStartupShutdownProperties.GetTaskmanXMLPath(this.m_aeinstallhomepath);
        if (buff.length() == 0) {
            logger.info(m_className, m_method, "Unable to locate XML config file to get the Component Manager properties.");
            throw new VWException("vw.integrator.base.VWCMCSMBCannotFindXMLConfig", "Unable to locate XML config file to get the Component Manager properties.");
        }
        this.taskManagerXMLPath = new String(buff);
        this.m_xmlHandler = new VWTaskXMLHandler(this.taskManagerXMLPath);
        logger.info(m_className, m_method, "Task manager XML Path=" + this.taskManagerXMLPath);
        if (this.m_xmlHandler == null) {
            logger.info(m_className, m_method, "xmlHandler is null!");
            return;
        }
        Node cmcNode = VWTaskXMLHandler.getNodeNamed(this.m_xmlHandler.getRootNode(), "ComponentManagers");
        if (cmcNode == null || cmcNode.getNodeType() != 1) {
            logger.info(m_className, m_method, "Unable to find ComponentManagers node.");
            return;
        }
        Node[] definitionNodes = VWTaskXMLHandler.getNodesNamed(cmcNode, "ComponentManager");
        int nDefs = definitionNodes == null ? 0 : definitionNodes.length;
        for (int i = 0; i < nDefs; ++i) {
            try {
                this.addComponentManagerNode(definitionNodes[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void cmFromXML(Node node) {
        String m_method = "cmFromXML";
        if (node == null || node.getNodeType() != 1) {
            logger.info(m_className, m_method, "Unable to find this Component Manager node.");
            return;
        }
        Element ele = (Element)node;
        this.routerURL = ele.getAttribute("RouterURL");
        try {
            if (ele.getAttributeNode("Queues") != null) {
                this.setQueues(ele.getAttribute("Queues"));
            }
            this.cmPort = Integer.parseInt(ele.getAttribute("Port"));
            this.password = ele.getAttribute("Options");
            logger.info(m_className, m_method, "Options=" + this.password);
            logger.info(m_className, m_method, "Options string from taskman.xml=" + this.password);
            if (ele.getAttributeNode("JNDIInitialContextFactory") != null) {
                this.setJNDIContext(ele.getAttribute("JNDIInitialContextFactory"));
            }
            this.reqlibs = ele.getAttribute("RequiredLibraries");
            this.eventPort = Integer.parseInt(ele.getAttribute("EventPort"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private String getAEInstallHomeURLForm() throws Exception {
        String m_method = "getAEInstallHomeURLForm";
        StringBuffer buffer = new StringBuffer().append(this.m_aeinstallhomepath);
        logger.info(m_className, m_method, "aeinstallhomepath=" + this.m_aeinstallhomepath);
        if (bWindowsOS) {
            int progPos;
            int sepPos = buffer.indexOf("\\");
            if (sepPos != -1) {
                buffer.replace(sepPos, sepPos + 1, "/");
            }
            if ((progPos = buffer.toString().toUpperCase(Locale.ENGLISH).indexOf("PROGRAM FILES")) != -1) {
                this.m_codebaseURLForm = buffer.replace(progPos, progPos + 13, "progra~1").toString();
                logger.info(m_className, m_method, "code base URL Form=" + this.m_codebaseURLForm);
            }
        }
        String aeInstallHomeURLForm = buffer.toString();
        logger.info(m_className, m_method, "aeInstallHome URL Form=" + aeInstallHomeURLForm);
        return aeInstallHomeURLForm;
    }

    private void setRMIServerCodeBaseProperty(Properties rmiSvrProps, String installHome) {
        System.setProperty("java.rmi.server.codebase", "file:/" + installHome + "\\Workplace\\WEB-INF\\" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\pe.jar" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\peResources.jar" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\Jace.jar" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\Sandesha.jar");
    }

    private String getRMIServerCodeBaseProperty() {
        return System.getProperty("java.rmi.server.codebase");
    }

    private void initCMProperties(Node node) throws Exception {
        String m_method = "initCMProperties";
        this.cmFromXML(node);
        System.setProperty("filenet.rmi.registry.inprocess", "true");
        String AEInstallHome = this.getAEInstallHomeURLForm();
        System.setProperty("filenet.ws.listener.properties.location", AEInstallHome + "/Workplace/WEB-INF");
        StringBuffer cp = new StringBuffer(System.getProperty("java.class.path"));
        VWAutoStartupShutdownProperties autoStStProps = VWAutoStartupShutdownProperties.getAutoStartupShutdownProperties();
        Properties tmProps = autoStStProps.readTaskmanPropertiesFile(this.m_aeinstallhomepath);
        String cmClassPath = tmProps.getProperty("TaskManager.ComponentManager.ClassPath", null);
        if (cmClassPath != null) {
            cp.append(File.pathSeparator);
            cp.append(cmClassPath);
        }
        if (this.reqlibs != null) {
            cp.append(File.pathSeparator);
            cp.append(this.reqlibs);
        }
        System.setProperty("filenet.wcmapiconfig", AEInstallHome + "/Workplace/WEB-INF/WcmApiConfig.properties");
        this.setRMIServerCodeBaseProperty(tmProps, AEInstallHome);
        logger.info(m_className, m_method, "java.rmi.server.codebase=" + this.getRMIServerCodeBaseProperty());
    }

    class MainThread
    extends Thread {
        private Throwable lastException = null;
        private VWComponentManagerCustomServiceMBean thisCM = null;

        public Throwable getLastException() {
            return this.lastException;
        }

        public MainThread(VWComponentManagerCustomServiceMBean aCMCS) {
            this.thisCM = aCMCS;
            this.setName("CMCustomService-Thread:" + m_className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String m_method = "MainThread.run";
            try {
                Thread.sleep(60000L);
                boolean done = false;
                while (!done && !VWComponentManagerCustomServiceMBean.this.m_StopRequested.booleanValue()) {
                    done = true;
                    VWComponentManagerCustomServiceMBean.this.initCMCollectionFromXML();
                    Node cmNode = null;
                    Enumeration e = VWComponentManagerCustomServiceMBean.this.m_componentManagers.elements();
                    while (e.hasMoreElements()) {
                        cmNode = (Node)e.nextElement();
                        VWComponentManagerCustomServiceMBean.this.initCMProperties(cmNode);
                        logger.info(m_className, m_method, "Starting component manager...");
                        VWComponentManagerCustomServiceMBean.this.startCM();
                        logger.info(m_className, m_method, "Component manager started successfully");
                    }
                }
            }
            catch (Exception e) {
                if (e != null) {
                    System.err.println(e.getMessage());
                }
                logger.throwing(m_className, m_method, e);
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }
}

